% ScriptVerificationReseMeantError

% Este script carrega o modelo de LUT caotica de 512 bits e a executa por
% um longo periodo, fornecendo sinais de reset, de forma a poder verificar
% qye a LUT caotica segue sempre o mesmo caminho no atrator caotico quando
% alimentada pela mesma condicao inicial. Plotamos as saidas em cores
% diferentes para mostrar que os caminhos sao os mesmos, e imprimimos na
% etiqueta do eixo X o erro medio (ME) que sempre e igual a zero, como deve
% ser.
% Este script eh muito parecida com aquele existente na pasta "SC-LUT 512\14 Chaotic SprottB LUT 512 Bits"
clear   

NOB = 22;

cd ..
cd '90 Configuration Data'
	eval(['load NumberOfBits_', num2str(NOB), '_Bits']);
    eval(['load PRM_', num2str(NOB), '_Bits']);
    eval(['load Slices_', num2str(NOB), '_Bits']);
cd ..
cd '94 Chaotic SprottB LUT All Bits'  

TimeStart = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]

Long_Run = 800; % The reference value should be 800, the time necessary for full dispersion
binpoint = max(Slices(:,3))+8;
numberbits = max(Slices(:,3))+33;
latenciamultiplier = 5;
Cycles_Repetition = 1; % Pode deixar como 1. It measures how many time a given imput is randonly repeted. Cycles_Repetition must be a Natural number between 1 and 7. Each picture has a number os graphs equal to Cycles_Repetition
Number_of_Repeted_Cycles = 1;   % Pode deixar como 1. It is used to calculate in which time the simulation stops (stoptime).

startime = 0;
stepsize = 0.01;
Period = (1/(latenciamultiplier*stepsize))*Long_Run;
stoptime = Number_of_Repeted_Cycles*Cycles_Repetition*Period;













eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_Figures']);
copyfile('ScriptVerificationReseMeantError.m',['', DATESTR(datenum(TimeStart),30), '_ScriptVerificationReseMeantError.m']);
copyfile('SprottB_LUT_All_Bits_3.mdl',['', DATESTR(datenum(TimeStart),30), '_SprottB_LUT_All_Bits_3.mdl']);

SimStart = now;            
TimeEndSimulationModel = datenum(TimeStart) + (((17*stoptime*Long_Run)/(48000*200))/1440);   % 48 mil passos de 200 (LongRun) ciclos demoraram 17 minutos
% TimeEndSimulationModel = datenum(TimeStart) + ((14*stoptime/19600)/1440);
fprintf('\n');
fprintf('The simulations Starts on %s\n', datestr(TimeStart));
fprintf('The simulation of the chaotic model will end on %s\n', datestr(TimeEndSimulationModel));
fprintf('\n');
fprintf('After the simulation of the chaotic model, we start plotting and saving the graphs\n');
fprintf('\n');
% open SprottB_LUT_All_Bits_3.mdl
sim('SprottB_LUT_All_Bits_3.mdl');   % Neste script, o que demora mesmo e este passo
PercentageProgress = 2;

% The number of Simulations is equal to the product of the number of xzero, yzero and zzero used
NumberSimulationsTotal = size(PRM,1) * Number_of_Repeted_Cycles;
NumberSimulationsLeft = NumberSimulationsTotal; % Before starting the simulation, the NumberSimulationsLeft is equal to the  NumberSimulationsTotal

for CircuitNumber = 1 : size(PRM,1);

    for CycleNumber = 1 : Number_of_Repeted_Cycles;
    
        Start_1 = Cycles_Repetition*Period*(CycleNumber-1) + 2;                     End_1 = Start_1 + Period - 1;
        Start_2 = End_1 + 1;                                                        End_2 = Start_2 + Period - 1;
        Start_3 = End_2 + 1;                                                        End_3 = Start_3 + Period - 1;
        Start_4 = End_3 + 1;                                                        End_4 = Start_4 + Period - 1;
        Start_5 = End_4 + 1;                                                        End_5 = Start_5 + Period - 1;
        Start_6 = End_5 + 1;                                                        End_6 = Start_6 + Period - 1;
        Start_7 = End_6 + 1;                                                        End_7 = Start_7 + Period - 1;
        
        figure(1)
        if Cycles_Repetition >= 1; eval(['plot(xoutx', num2str(CircuitNumber-1), '(Start_1:End_1),youtx', num2str(CircuitNumber-1), '(Start_1:End_1),''g+'');' ]); grid on; hold on; end
        if Cycles_Repetition >= 2; eval(['plot(xoutx', num2str(CircuitNumber-1), '(Start_2:End_2),youtx', num2str(CircuitNumber-1), '(Start_2:End_2),''yo'');' ]); end
        if Cycles_Repetition >= 3; eval(['plot(xoutx', num2str(CircuitNumber-1), '(Start_3:End_3),youtx', num2str(CircuitNumber-1), '(Start_3:End_3),''bx'');' ]); end
        if Cycles_Repetition >= 4; eval(['plot(xoutx', num2str(CircuitNumber-1), '(Start_4:End_4),youtx', num2str(CircuitNumber-1), '(Start_4:End_4),''cd'');' ]); end
        if Cycles_Repetition >= 5; eval(['plot(xoutx', num2str(CircuitNumber-1), '(Start_5:End_5),youtx', num2str(CircuitNumber-1), '(Start_5:End_5),''m.'');' ]); end
        if Cycles_Repetition >= 6; eval(['plot(xoutx', num2str(CircuitNumber-1), '(Start_6:End_6),youtx', num2str(CircuitNumber-1), '(Start_6:End_6),''kp'');' ]); end
        if Cycles_Repetition >= 7; eval(['plot(xoutx', num2str(CircuitNumber-1), '(Start_7:End_7),youtx', num2str(CircuitNumber-1), '(Start_7:End_7),''r*'');' ]); end
        eval(['XZ = xzero', num2str(CircuitNumber-1), '(Start_1);']);
        eval(['YZ = yzero', num2str(CircuitNumber-1), '(Start_1);']);
        eval(['ZZ = zzero', num2str(CircuitNumber-1), '(Start_1);']);
        plot(XZ,YZ,'rs');
        % The diferrence between sucessive Cycles, point to point, must be equal to zero. A variavel ME significa Erro Medio, deve ser sempre zero, e e impresso no XLABEL de cada figura salva em disco rigido para rapida conferencia
        eval(['ME = mean(xoutx', num2str(CircuitNumber-1), '(Start_1:End_1)-xoutx', num2str(CircuitNumber-1), '(Start_2:End_2));' ]);
        % Now we put title and axis label no the figure axis
        eval(['title(''2D Attractor | Cycle ', num2str(CycleNumber-1), ' | (xzero', num2str(CircuitNumber-1), ',yzero', num2str(CircuitNumber-1), ',zzero', num2str(CircuitNumber-1), ') = (', num2str(XZ), ',', num2str(YZ), ',', num2str(ZZ), ')', ''');' ]);
        eval(['xlabel(''XoutX', num2str(CircuitNumber-1), ' | Mean = ', num2str(ME), ' | ', num2str(Cycles_Repetition), ' curves ploted togheter (g+ yo bx cd m. kp r*)', ''')']);
        eval(['ylabel(''YoutX', num2str(CircuitNumber-1),''')']);
        % Now we save the produced figures in 2 different formats
        eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures']);
        filename = ([DATESTR(datevec(now),30), '_2D_Attractor_Output', num2str(CircuitNumber-1), '_Cycle', num2str(CycleNumber-1), '.fig']);
        saveas(1, filename, 'fig'); 
        AXIS([-15 15 -8 8]);
        filename = ([DATESTR(datevec(now),30), '_2D_Attractor_Output', num2str(CircuitNumber-1), '_Cycle', num2str(CycleNumber-1), '.emf']);
        saveas(1, filename, 'emf');
        cd ..
        close(1)
	
        
%         pause(1)
        figure(2)
        if Cycles_Repetition >= 1; eval(['plot3(xoutx', num2str(CircuitNumber-1), '(Start_1:End_1),youtx', num2str(CircuitNumber-1), '(Start_1:End_1),zoutx', num2str(CircuitNumber-1), '(Start_1:End_1),''g+'');' ]); grid on; hold on; end
        if Cycles_Repetition >= 2; eval(['plot3(xoutx', num2str(CircuitNumber-1), '(Start_2:End_2),youtx', num2str(CircuitNumber-1), '(Start_2:End_2),zoutx', num2str(CircuitNumber-1), '(Start_2:End_2),''yo'');' ]); end
        if Cycles_Repetition >= 3; eval(['plot3(xoutx', num2str(CircuitNumber-1), '(Start_3:End_3),youtx', num2str(CircuitNumber-1), '(Start_3:End_3),zoutx', num2str(CircuitNumber-1), '(Start_3:End_3),''bx'');' ]); end
        if Cycles_Repetition >= 4; eval(['plot3(xoutx', num2str(CircuitNumber-1), '(Start_4:End_4),youtx', num2str(CircuitNumber-1), '(Start_4:End_4),zoutx', num2str(CircuitNumber-1), '(Start_4:End_4),''cd'');' ]); end
        if Cycles_Repetition >= 5; eval(['plot3(xoutx', num2str(CircuitNumber-1), '(Start_5:End_5),youtx', num2str(CircuitNumber-1), '(Start_5:End_5),zoutx', num2str(CircuitNumber-1), '(Start_5:End_5),''m.'');' ]); end
        if Cycles_Repetition >= 6; eval(['plot3(xoutx', num2str(CircuitNumber-1), '(Start_6:End_6),youtx', num2str(CircuitNumber-1), '(Start_6:End_6),zoutx', num2str(CircuitNumber-1), '(Start_6:End_6),''kp'');' ]); end
        if Cycles_Repetition >= 7; eval(['plot3(xoutx', num2str(CircuitNumber-1), '(Start_7:End_7),youtx', num2str(CircuitNumber-1), '(Start_7:End_7),zoutx', num2str(CircuitNumber-1), '(Start_7:End_7),''r*'');' ]); end
        plot3(XZ,YZ,ZZ,'rs');
        % Now we put title and axis label no the figure axis
        eval(['title(''3D Attractor | Cycle ', num2str(CycleNumber-1), ' | (xzero', num2str(CircuitNumber-1), ',yzero', num2str(CircuitNumber-1), ',zzero', num2str(CircuitNumber-1), ') = (', num2str(XZ), ',', num2str(YZ), ',', num2str(ZZ), ')', ''');' ]);
        eval(['xlabel(''XoutX', num2str(CircuitNumber-1), ''')']);
        eval(['ylabel(''YoutX', num2str(CircuitNumber-1),''')']);
        % Now we save the produced figures in 2 different formats
        eval(['cd ', DATESTR(datenum(TimeStart),30), '_Figures']);
        filename = ([DATESTR(datevec(now),30), '_3D_Attractor_Output', num2str(CircuitNumber-1), '_Cycle', num2str(CycleNumber-1), '.fig']);
        saveas(2, filename, 'fig');
        filename = ([DATESTR(datevec(now),30), '_3D_Attractor_Output', num2str(CircuitNumber-1), '_Cycle', num2str(CycleNumber-1), '.emf']);
        saveas(2, filename, 'emf');
        cd ..
        close(2)

        NumberSimulationsLeft = NumberSimulationsLeft - 1;
        % Calculation of End of Simulation Time    
        TimeActual = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]
        TimeElapsed = datenum(TimeActual) - datenum(TimeStart); % Time is numerical form in reference to 01JAN0000
        TimeEnd = datenum(TimeActual) + (TimeElapsed/(NumberSimulationsTotal-NumberSimulationsLeft))*(NumberSimulationsLeft);
        Percentage = 100*(NumberSimulationsTotal-NumberSimulationsLeft)/(NumberSimulationsTotal);
        if Percentage > PercentageProgress
            fprintf(1,'%2.0f%% done. Starts: %s. Now: %s. End: %s \n', Percentage, datestr(TimeStart), datestr(now), datestr(TimeEnd))
            PercentageProgress = PercentageProgress + 5;
        end


	end
    
end
    
% Now it plays a sound that indicates the end of the simulation
[SimEnd,FqSp,NBits]=wavread('EndOfSimulation.wav');
soundsc(SimEnd,FqSp)
fprintf('\n')
% Now it saves and prints the End of Simulation Time
EndOfSimulation = datestr(now);
fprintf('The simulations Starts on %s\n', datestr(TimeStart));
fprintf('The simulations Ends on %s\n', datestr(EndOfSimulation));
fprintf('\n')
